jQuery(document).ready(function(){
	$("#seccionEstadoTramitacion_legend").on("click",function(){$("#seccionEstadoTramitacion").toggle();});	

	var plugins;
	if(esUsuarioModificacion){
		$("#expFiltro_toolbar").addButton({i18nCaption:"archivarExpedientes",right:false, click:archivarExpedientes},$.rup.i18n.app["botones"]);
		
		plugins =[
		        	"feedback",
		        	"fluid",
		        	"toolbar",
		        	"multiselection",
		        	"formEdit",
		        	"filter"
		    ];
	} else {
		plugins =[
		        	"feedback",
		        	"fluid",
		        	"toolbar",
		        	"formEdit",
		        	"filter"
		    ];
		
	}
	
	$("#expFiltro").rup_table({
		url: "../ab03b10v00Archivo",
		colNames: [
			$.rup.i18n.app.expedientes.expediente,
			$.rup.i18n.app.trabajadores.nif,
			$.rup.i18n.app.expedientes.nombre,
			$.rup.i18n.app.expedientes.cifNif,
			$.rup.i18n.app.expedientes.razonSocial
		],
		colModel: [
			{ 	name: "idExpediente",
				align: "right", 
				width: 50, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "niftitular010", 
				align: "right", 
				width: 40, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "nombretitular010", 
				width: 155,  
				resizable: true, 
				sortable: true,
				formatter : function(cellval, opts, rwd, act) {
					return rwd.nombretitular010 + " " + rwd.ape1titular010 + " " + rwd.ape2titular010 ;
				}
			},
			{ 	name: "nifempresa047", 
				align: "right", 
				width: 40,  
				resizable: true, 
				sortable: true
			},
			{ 	name: "nombreempresa047", 
				align: "left", 
				width: 155, 
				resizable: true, 
				sortable: true
			}
		],
	    model:"Ab03b10v00",
	    usePlugins:plugins,
		primaryKey: "idExpediente",
		sortname: "idExpediente",
		sortorder: "asc",
		loadOnStartUp: true,
		feedback:{
			config:{
				block: false
			}
		},
		toolbar: {
			createDefaultToolButtons: false,
			buttons: []
		}
	});


	$("#expFiltro").on("rupTable_beforeEditRow", 
		function(deleteOptions, selectedRow){
			if ($("#expFiltro_filter_form").validate().checkForm()) {
				fila = $("#expFiltro").rup_grid('getGridParam', 'selrow');
				obj = $("#expFiltro").rup_grid('getRowData', fila);

				window.location.href = $.rup.CTX_PATH + "ab03b10t00/irDetalle/"+obj.idExpediente;

				return false;
			} else {
				return false;
			}
		});	
	
	$("#expFiltro_filter_form").rup_validate({
		feedback:$("#expFiltro_feedback"),
		liveCheckingErrors: true,
		rules:{
			"idProv010":{digits:true},
			"idAno010":{digits:true},
			"id010":{digits:true}
		}
	});
	
	$("#expFiltro").on("rupTable_beforeFilter", 
	function(){
		if(ab03bUtils.form.validate($("#expFiltro_filter_form"))){	
			return true;
		} else {
			return false;
		}
	});	
});

function ocultar(capaAcordeon){
	$(capaAcordeon).toggle();
};

//Funcion limpiar
$('#expFiltro_filter_cleanLink').click(function(event){
	resetFiltro($("#expFiltro_filter_form"));
	
	//se borran los mensajes de errores que se muestran en el feedback
	$("#expFiltro_filter_form").validate().submitted = {};
	//se cierra el feedback
	$("#expFiltro_feedback").rup_feedback("close");
	
	$("#expFiltro").rup_table('filter'); 
	
	// se quitan las imagenes que marcan el error
	$(".rup-maint_validateIcon", $("#expFiltro_filter_form")).remove();
});

function haySeleccionados(){
	if ($("#expFiltro").rup_table("getSelectedIds").selectedAll){
		return true;
	} else {
		if ($("#expFiltro").rup_table("getSelectedIds").selectedIds != undefined){
			return true;
		}
	}
	
}

function archivarExpedientes(){
	if(haySeleccionados()){
		
		var todosSeleccionados = $("#expFiltro").rup_table("getSelectedIds").selectedAll;
		$("#todosSeleccionados").val(todosSeleccionados);
		
		$("#seleccionados").val("");
		if ($("#expFiltro").rup_table("getSelectedIds").selectedIds != undefined) {
			$("#seleccionados").val($("#expFiltro").rup_table("getSelectedIds").selectedIds);
		} 
		
		var prov="";
		if (permisoDelegacion)
			prov= delegacionUsu;
		else
			prov= $('#idProv010').val();
		
		var urlCarga = "/ab03bAmiantoWar/ab03b10v00Archivo/marcarArchivar";
		waitDialog();
		$.rup_ajax({
			url : urlCarga,
			dataType : 'json',
			data : {
				'seleccionados' : $("#seleccionados").val(),
				'todosSeleccionados' : todosSeleccionados,
				'prov': prov,
				'anyo': $('#idAno010').val(),
				'id': $('#id010').val()
			},
			cache : false,
			type : "GET",
			contentType : 'application/json',
			async : false,
			success : function(xhr, ajaxOptions) {
				ab03bUtils.feedback.pintarFeedback($.rup.i18nParse($.rup.i18n.app,"mensajes.okGenerico"),  "ok",$("#expFiltro_feedback"));
			},
			error : function(error){
				pintarFeedbackError(error.responseText, $("#expFiltro_feedback"));
			},
			complete:function(xhr, ajaxOptions) {
				$("#expFiltro").rup_table("clearGridData", true);
				$("#expFiltro").rup_table("reloadGrid", false);
				//Cuando hay Multiseleccion::: Borro los registros seleccionados que han sido borrados
				$("#expFiltro").rup_table("resetSelection");
				closeWaitDialog();
			}
		});
	}else{
		//no hay ninguno seleccionado
		ab03bUtils.feedback.pintarFeedbackError($.rup.i18nParse($.rup.i18n.app,"mensajes.noSeleccion"), $("#expFiltro_feedback"));
		return false;
	}
}
